﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PI.ZB.N1200.ELearning.WebApplication.Accounts;

namespace PI.ZB.N1200.ELearning.WebApplication.Statistics
{
    public abstract partial class StatsBaseComponent : BaseComponent
    {
        public abstract class StatsPanel
        {
            public enum EditModeType
            {
                NotLoaded = -1,
                None = 0,
                EditOrInsert = 1,
                Remove = 2,
            }

            private StatsBaseComponent _Component = null;

            protected StatsBaseComponent Component
            {
                get
                {
                    return _Component;
                }
            }

            public StatsPanel(StatsBaseComponent BaseComponent)
            {
                _Component = BaseComponent;
            }

            public abstract void Load();
            public abstract bool Save();

            #region Property i parametry czytane z URLa
            private EditModeType _editMode = EditModeType.NotLoaded;
            protected EditModeType EditMode
            {
                get
                {
                    if (_editMode == EditModeType.NotLoaded)
                    {
                        _editMode = EditModeType.None;
                        try
                        {
                            _editMode = (EditModeType)Component.Environment.GetRequestParamInt("editmode");
                        }
                        catch { }
                    }
                    return _editMode;
                }
            }

            private long? _competenceID = null;
            protected long? CompetenceID
            {
                get
                {
                    if (!_competenceID.HasValue)
                    {
                        string _competenceIDString = Component.Environment.GetRequestParamString("competenceid");
                        if (!string.IsNullOrEmpty(_competenceIDString))
                        {
                            long _id = 0;
                            if (long.TryParse(_competenceIDString, out _id))
                            {
                                _competenceID = _id;
                            }
                        }
                    }
                    return _competenceID;
                }
            }

            private long? _studentID = null;
            protected long? StudentID
            {
                get
                {
                    if (!_studentID.HasValue)
                    {
                        string _studentIDString = Component.Environment.GetRequestParamString("studentid");
                        if (!string.IsNullOrEmpty(_studentIDString))
                        {
                            long _id = 0;
                            if (long.TryParse(_studentIDString, out _id))
                            {
                                _studentID = _id;
                            }
                        }
                    }
                    return _studentID;
                }
            }

            private long? _classID = null;
            protected long? ClassID
            {
                get
                {
                    if (!_classID.HasValue)
                    {
                        string _classIDString = Component.Environment.GetRequestParamString("classid");
                        if (!string.IsNullOrEmpty(_classIDString))
                        {
                            long _id = 0;
                            if (long.TryParse(_classIDString, out _id))
                            {
                                _classID = _id;
                            }
                        }
                    }
                    return _classID;
                }
            }
            #endregion

            #region Poziom I - Lista klas w widoku Instruktora
            public void AppendToXML(List<BL.BO.View.StatisticStudent> StudentStatisticList)
            {
                Component.XML.Element.Start("StatisticList");
                foreach (BL.BO.View.StatisticStudent _loopStudentStatistic in StudentStatisticList)
                {
                    AppendToXML(_loopStudentStatistic);
                }
                Component.XML.Element.End();
            }

            /// <summary>
            /// Statystyka albo studenta albo wszystkich klas instruktora
            /// W zaleznosci od poziomu nalezy przekazac TRUE albo FALSE
            /// </summary>
            /// <param name="StudentStatistic"></param>
            /// <param name="ClassLevel"></param>
            public void AppendToXML(BL.BO.View.StatisticStudent StudentStatistic)
            {
                Component.XML.Element.Start("Statistic");
                Component.XML.Element.Attribute("AdvancedTestEndMaxPoints", StudentStatistic.AdvancedTestEndMaxPoints);
                Component.XML.Element.Attribute("AdvancedTestEndPoints", StudentStatistic.AdvancedTestEndPoints);
                Component.XML.Element.Attribute("AdvancedTestStartMaxPoints", StudentStatistic.AdvancedTestStartMaxPoints);
                Component.XML.Element.Attribute("AdvancedTestStartPoints", StudentStatistic.AdvancedTestStartPoints);
                Component.XML.Element.Attribute("CaseStudyMaxPoints", StudentStatistic.CaseStudyMaxPoints);
                Component.XML.Element.Attribute("CaseStudyPoints", StudentStatistic.CaseStudyPoints);
                Component.XML.Element.Attribute("ClassID", StudentStatistic.ClassID);
                Component.XML.Element.Attribute("ClassName", StudentStatistic.ClassName);
                Component.XML.Element.Attribute("CompetenceMaxPoints", StudentStatistic.CompetenceMaxPoints);
                Component.XML.Element.Attribute("CompetencePartDone", StudentStatistic.CompetencePartDone);
                Component.XML.Element.Attribute("CompetencePartDoneAvg", StudentStatistic.CompetencePartDoneAvg);
                Component.XML.Element.Attribute("CompetencePointsByWeight", StudentStatistic.CompetencePointsByWeight);
                Component.XML.Element.Attribute("Forename", StudentStatistic.Forename);
                Component.XML.Element.Attribute("ID", StudentStatistic.ID);
                Component.XML.Element.Attribute("KnowledgeTestEndMaxPoints", StudentStatistic.KnowledgeTestEndMaxPoints);
                Component.XML.Element.Attribute("KnowledgeTestEndPoints", StudentStatistic.KnowledgeTestEndPoints);
                Component.XML.Element.Attribute("KnowledgeTestStartMaxPoints", StudentStatistic.KnowledgeTestStartMaxPoints);
                Component.XML.Element.Attribute("KnowledgeTestStartPoints", StudentStatistic.KnowledgeTestStartPoints);
                Component.XML.Element.Attribute("ResetCount", StudentStatistic.ResetCount);
                Component.XML.Element.Attribute("Surename", StudentStatistic.Surename);

                Component.XML.Element.Attribute("AdvancedTestEndPointsPercent", StudentStatistic.AdvancedTestEndPointsPercent);
                Component.XML.Element.Attribute("AdvancedTestStartPointsPercent", StudentStatistic.AdvancedTestStartPointsPercent);
                Component.XML.Element.Attribute("CaseStudyPointsPercent", StudentStatistic.CaseStudyPointsPercent);
                Component.XML.Element.Attribute("CompetencePointsPercent", StudentStatistic.CompetencePointsPercent);
                Component.XML.Element.Attribute("KnowledgeTestEndPointsPercent", StudentStatistic.KnowledgeTestEndPointsPercent);
                Component.XML.Element.Attribute("KnowledgeTestStartPointsPercent", StudentStatistic.KnowledgeTestStartPointsPercent);

                Component.XML.Element.Attribute("GameCash", StudentStatistic.GameCashValue);
                Component.XML.Element.Attribute("Salary", StudentStatistic.SalaryValue);
                Component.XML.Element.Attribute("SalaryAvg", StudentStatistic.SalaryAvg);
                Component.XML.Element.Attribute("GameCashAvg", StudentStatistic.GameCashAvg);

                Component.XML.Element.Attribute("ClassLevel", 1);
                
                // tutaj stopnie trudnosci rozbite
                AppendStatisticAdvancedLevelList(Component.BLELearning.Statistic.AdvancedLevel.RestoreByClassID(StudentStatistic.ClassID));

                Component.XML.Element.End();
            }
            #endregion

            #region Poziom I - Lista studentow w widoku Instruktora
            public void AppendToXML(List<BL.BO.Student> StudentList)
            {
                Component.XML.Element.Start("StatisticList");
                foreach (BL.BO.Student _loopStudent in StudentList)
                {
                    AppendToXML(_loopStudent);
                }
                Component.XML.Element.End();
            }

            /// <summary>
            /// Statystyka studenta 
            /// W zaleznosci od poziomu nalezy przekazac TRUE albo FALSE
            /// </summary>
            /// <param name="StudentStatistic"></param>
            /// <param name="ClassLevel"></param>
            public void AppendToXML(BL.BO.Student Student, bool IsRanking=false)
            {
                if (IsRanking)
                {
                    Component.XML.Element.Start("RankingStudent");
                    Component.XML.Element.Attribute("ClassID", Student.ClassID);
                    Component.XML.Element.Attribute("ClassName", GetClassName(Student.ClassID));
                    Component.XML.Element.Attribute("Forename", Student.Forename);
                    Component.XML.Element.Attribute("GameCash", Student.GameCashValue);
                    Component.XML.Element.Attribute("ID", Student.ID);
                    Component.XML.Element.Attribute("Salary", Student.SalaryValue);
                    Component.XML.Element.Attribute("Surename", Student.Surename);
                    Component.XML.Element.Attribute("DisplayValue", Student.DisplayValue);
                    Component.XML.Element.Attribute("CurrentAdvancedLevelID", Student.CurrentAdvancedLevelID);
                    Component.XML.Element.Attribute("CurrentEvaluationSheetID", Student.CurrentEvaluationSheetID);
                    Component.XML.Element.Attribute("CurrentEvaluationSheetName", GetEvaluationName(Student.CurrentEvaluationSheetID));
                    Component.XML.Element.Attribute("CompetencePartDoneAvg", Student.CompetencePartDoneAvg);
                }
                else
                {
                    Component.XML.Element.Start("Statistic");
                    Component.XML.Element.Attribute("AdvancedTestEndMaxPoints", Student.AdvancedTestEndMaxPoints);
                    Component.XML.Element.Attribute("AdvancedTestEndPoints", Student.AdvancedTestEndPoints);
                    Component.XML.Element.Attribute("AdvancedTestStartMaxPoints", Student.AdvancedTestStartMaxPoints);
                    Component.XML.Element.Attribute("AdvancedTestStartPoints", Student.AdvancedTestStartPoints);
                    Component.XML.Element.Attribute("CaseStudyMaxPoints", Student.CaseStudyMaxPoints);
                    Component.XML.Element.Attribute("CaseStudyPoints", Student.CaseStudyPoints);
                    Component.XML.Element.Attribute("ClassID", Student.ClassID);
                    Component.XML.Element.Attribute("ClassName", GetClassName(Student.ClassID));
                    Component.XML.Element.Attribute("CompetenceMaxPoints", Student.CompetenceMaxPoints);
                    Component.XML.Element.Attribute("CompetencePartDone", Student.CompetencePartDone);
                    Component.XML.Element.Attribute("CompetencePartDoneAvg", Student.CompetencePartDoneAvg);
                    Component.XML.Element.Attribute("CompetencePointsByWeight", Student.CompetencePointsByWeight);
                    Component.XML.Element.Attribute("Forename", Student.Forename);
                    Component.XML.Element.Attribute("GameCash", Student.GameCashValue);
                    Component.XML.Element.Attribute("ID", Student.ID);
                    Component.XML.Element.Attribute("KnowledgeTestEndMaxPoints", Student.KnowledgeTestEndMaxPoints);
                    Component.XML.Element.Attribute("KnowledgeTestEndPoints", Student.KnowledgeTestEndPoints);
                    Component.XML.Element.Attribute("KnowledgeTestStartMaxPoints", Student.KnowledgeTestStartMaxPoints);
                    Component.XML.Element.Attribute("KnowledgeTestStartPoints", Student.KnowledgeTestStartPoints);
                    Component.XML.Element.Attribute("ResetCount", Student.ResetCount);
                    Component.XML.Element.Attribute("Salary", Student.SalaryValue);
                    Component.XML.Element.Attribute("Surename", Student.Surename);

                    Component.XML.Element.Attribute("AdvancedTestEndPointsPercent", Student.AdvancedTestEndPointsPercent);
                    Component.XML.Element.Attribute("AdvancedTestStartPointsPercent", Student.AdvancedTestStartPointsPercent);
                    Component.XML.Element.Attribute("CaseStudyPointsPercent", Student.CaseStudyPointsPercent);
                    Component.XML.Element.Attribute("CompetencePointsPercent", Student.CompetencePointsPercent);
                    Component.XML.Element.Attribute("KnowledgeTestEndPointsPercent", Student.KnowledgeTestEndPointsPercent);
                    Component.XML.Element.Attribute("KnowledgeTestStartPointsPercent", Student.KnowledgeTestStartPointsPercent);
                    Component.XML.Element.Attribute("SalaryAvg", Student.SalaryValue);
                    Component.XML.Element.Attribute("GameCashAvg", Student.GameCashValue);

                    Component.XML.Element.Attribute("ClassLevel", 0);

                    Component.XML.Element.Attribute("AdvancedTestEndEvaluationSheetID", Student.AdvancedTestEndEvaluationSheetID);
                    Component.XML.Element.Attribute("AdvancedTestStartEvaluationSheetID", Student.AdvancedTestStartEvaluationSheetID);
                    Component.XML.Element.Attribute("CompetenceEvaluationSheetID", Student.CompetenceEvaluationSheetID);
                    Component.XML.Element.Attribute("CurrentAdvancedLevelID", Student.CurrentAdvancedLevelID);
                    Component.XML.Element.Attribute("CurrentEvaluationSheetID", Student.CurrentEvaluationSheetID);
                    Component.XML.Element.Attribute("KnowledgeTestEndAdvancedLevelID", Student.KnowledgeTestEndAdvancedLevelID);
                    Component.XML.Element.Attribute("KnowledgeTestStartAdvancedLevelID", Student.KnowledgeTestStartAdvancedLevelID);

                    // tutaj stopnie trudnosci rozbite
                    AppendStatisticAdvancedLevelList(Component.BLELearning.Statistic.AdvancedLevel.Restore(Student));
                }

                Component.XML.Element.End();
            }
            #endregion

            #region Poziom II = Szczegoly klasy w widoku Instruktora 
            /// <summary>
            /// Kompetencje glowne sumowane w widoku dla klasy (w kontekscie instruktora)
            /// </summary>
            /// <param name="CompetenceStatisticList"></param>
            public void AppendToXML(BL.BO.Class Class, List<BL.BO.View.StatisticCompetence> CompetenceStatisticList)
            {
                Component.XML.Element.Start("CompetenceStatisticList");
                foreach (BL.BO.View.StatisticCompetence _loopCompetenceStatistic in CompetenceStatisticList)
                {
                    AppendToXML(Class, _loopCompetenceStatistic);
                }
                Component.XML.Element.End();
            }

            public void AppendToXML(BL.BO.Class Class, BL.BO.View.StatisticCompetence CompetenceStatistic)
            {
                Component.XML.Element.Start("CompetenceStatistic");
                Component.XML.Element.Attribute("Abbreviation", CompetenceStatistic.Abbreviation);
                Component.XML.Element.Attribute("CaseStudyMaxPoints", CompetenceStatistic.CaseStudyMaxPoints);
                Component.XML.Element.Attribute("CaseStudyPoints", CompetenceStatistic.CaseStudyPoints);
                Component.XML.Element.Attribute("CompetenceMaxPoints", CompetenceStatistic.CompetenceMaxPoints);
                Component.XML.Element.Attribute("CompetencePartDone", CompetenceStatistic.CompetencePartDone);
                Component.XML.Element.Attribute("CompetencePointsByWeight", CompetenceStatistic.CompetencePointsByWeight);
                Component.XML.Element.Attribute("ID", CompetenceStatistic.ID);
                Component.XML.Element.Attribute("ClassID", Class.ID);
                Component.XML.Element.Attribute("Name", CompetenceStatistic.Name);
                Component.XML.Element.Attribute("ResetCount", CompetenceStatistic.ResetCount);
                Component.XML.Element.Attribute("Salary", CompetenceStatistic.SalaryValue);

                Component.XML.Element.Attribute("DisplayValue", CompetenceStatistic.DisplayValue);
                Component.XML.Element.Attribute("CaseStudyPointsPercent", CompetenceStatistic.CaseStudyPointsPercent);
                Component.XML.Element.Attribute("CompetencePointsPercent", CompetenceStatistic.CompetencePointsPercent);
                Component.XML.Element.Attribute("CompetencePartDoneAvg", CompetenceStatistic.CompetencePartDoneAvg);

                // tutaj stopnie trudnosci rozbite
                AppendStatisticAdvancedLevelList(Component.BLELearning.Statistic.AdvancedLevel.Restore(Class, CompetenceStatistic.ID));

                Component.XML.Element.End();
            }
            #endregion

            #region Poziom II = Szczegoly studenta w widoku Instruktora
            /// <summary>
            /// Kompetencje glowne sumowane w widoku dla klasy (w kontekscie instruktora)
            /// </summary>
            /// <param name="CompetenceStatisticList"></param>
            public void AppendToXML(BL.BO.Student Student, List<BL.BO.View.StatisticCompetence> CompetenceStatisticList)
            {
                Component.XML.Element.Start("CompetenceStatisticList");
                foreach (BL.BO.View.StatisticCompetence _loopCompetenceStatistic in CompetenceStatisticList)
                {
                    AppendToXML(Student, _loopCompetenceStatistic);
                }
                Component.XML.Element.End();
            }

            public void AppendToXML(BL.BO.Student Student, BL.BO.View.StatisticCompetence CompetenceStatistic)
            {
                Component.XML.Element.Start("CompetenceStatistic");
                Component.XML.Element.Attribute("Abbreviation", CompetenceStatistic.Abbreviation);
                Component.XML.Element.Attribute("CaseStudyMaxPoints", CompetenceStatistic.CaseStudyMaxPoints);
                Component.XML.Element.Attribute("CaseStudyPoints", CompetenceStatistic.CaseStudyPoints);
                Component.XML.Element.Attribute("CompetenceMaxPoints", CompetenceStatistic.CompetenceMaxPoints);
                Component.XML.Element.Attribute("CompetencePartDone", CompetenceStatistic.CompetencePartDone);
                Component.XML.Element.Attribute("CompetencePointsByWeight", CompetenceStatistic.CompetencePointsByWeight);
                Component.XML.Element.Attribute("ID", CompetenceStatistic.ID);
                Component.XML.Element.Attribute("ClassID", Student.ClassID);
                Component.XML.Element.Attribute("StudentID", Student.ID);
                Component.XML.Element.Attribute("Name", CompetenceStatistic.Name);
                Component.XML.Element.Attribute("ResetCount", CompetenceStatistic.ResetCount);
                Component.XML.Element.Attribute("Salary", CompetenceStatistic.SalaryValue);

                Component.XML.Element.Attribute("DisplayValue", CompetenceStatistic.DisplayValue);
                Component.XML.Element.Attribute("CaseStudyPointsPercent", CompetenceStatistic.CaseStudyPointsPercent);
                Component.XML.Element.Attribute("CompetencePointsPercent", CompetenceStatistic.CompetencePointsPercent);
                Component.XML.Element.Attribute("CompetencePartDoneAvg", CompetenceStatistic.CompetencePartDoneAvg);

                // tutaj stopnie trudnosci rozbite
                AppendStatisticAdvancedLevelList(Component.BLELearning.Statistic.AdvancedLevel.Restore(Student, CompetenceStatistic.ID));

                Component.XML.Element.End();
            }
            #endregion

            #region Poziom III = Szczegoly kompetencji glownej w kontekscie klasy w widoku Instruktora
            /// <summary>
            /// Kompetencje skladowe sumowane dla kompetencji glownej w widoku dla klasy (w kontekscie instruktora)
            /// </summary>
            /// <param name="CompetenceStatisticList"></param>
            public void AppendToXML(BL.BO.Class Class, List<BL.BO.View.StatisticCompetencePart> CompetencePartStatisticList)
            {
                Component.XML.Element.Start("CompetencePartStatisticList");
                foreach (BL.BO.View.StatisticCompetencePart _loopCompetencePartStatistic in CompetencePartStatisticList)
                {
                    AppendToXML(Class, _loopCompetencePartStatistic);
                }
                Component.XML.Element.End();
            }

            public void AppendToXML(BL.BO.Class Class, BL.BO.View.StatisticCompetencePart CompetencePartStatistic)
            {
                Component.XML.Element.Start("CompetencePartStatistic");
                Component.XML.Element.Attribute("Abbreviation", CompetencePartStatistic.Abbreviation);
                Component.XML.Element.Attribute("CaseStudyMaxPoints", CompetencePartStatistic.CaseStudyMaxPoints);
                Component.XML.Element.Attribute("CaseStudyPoints", CompetencePartStatistic.CaseStudyPoints);
                Component.XML.Element.Attribute("CompetenceID", CompetencePartStatistic.CompetenceID);
                Component.XML.Element.Attribute("CompetenceMaxPoints", CompetencePartStatistic.CompetenceMaxPoints);
                Component.XML.Element.Attribute("CompetencePoints", CompetencePartStatistic.CompetencePoints);
                Component.XML.Element.Attribute("CompetencePointsByWeight", CompetencePartStatistic.CompetencePointsByWeight);
                Component.XML.Element.Attribute("ID", CompetencePartStatistic.ID);
                Component.XML.Element.Attribute("Name", CompetencePartStatistic.Name);
                Component.XML.Element.Attribute("ResetCount", CompetencePartStatistic.ResetCount);
                Component.XML.Element.Attribute("Salary", CompetencePartStatistic.SalaryValue);

                Component.XML.Element.Attribute("DisplayValue", CompetencePartStatistic.DisplayValue);
                Component.XML.Element.Attribute("CaseStudyPointsPercent", CompetencePartStatistic.CaseStudyPointsPercent);
                Component.XML.Element.Attribute("CompetencePointsPercent", CompetencePartStatistic.CompetencePointsPercent);

                // tutaj stopnie trudnosci rozbite
                AppendStatisticAdvancedLevelList(Component.BLELearning.Statistic.AdvancedLevel.Restore(Class, CompetencePartStatistic.CompetenceID, CompetencePartStatistic.ID));

                Component.XML.Element.End();
            }
            #endregion

            #region Poziom III = Szczegoly kompetencji glownej w kontekscie studenta w widoku Instruktora
            /// <summary>
            /// Kompetencje skladowe sumowane dla kompetencji glownej w widoku dla studenta (w kontekscie instruktora)
            /// </summary>
            /// <param name="CompetenceStatisticList"></param>
            public void AppendToXML(BL.BO.Student Student, List<BL.BO.View.StatisticCompetencePart> CompetencePartStatisticList)
            {
                Component.XML.Element.Start("CompetencePartStatisticList");
                foreach (BL.BO.View.StatisticCompetencePart _loopCompetencePartStatistic in CompetencePartStatisticList)
                {
                    AppendToXML(Student, _loopCompetencePartStatistic);
                }
                Component.XML.Element.End();
            }

            public void AppendToXML(BL.BO.Student Student, BL.BO.View.StatisticCompetencePart CompetencePartStatistic)
            {
                Component.XML.Element.Start("CompetencePartStatistic");
                Component.XML.Element.Attribute("Abbreviation", CompetencePartStatistic.Abbreviation);
                Component.XML.Element.Attribute("CaseStudyMaxPoints", CompetencePartStatistic.CaseStudyMaxPoints);
                Component.XML.Element.Attribute("CaseStudyPoints", CompetencePartStatistic.CaseStudyPoints);
                Component.XML.Element.Attribute("CompetenceID", CompetencePartStatistic.CompetenceID);
                Component.XML.Element.Attribute("CompetenceMaxPoints", CompetencePartStatistic.CompetenceMaxPoints);
                Component.XML.Element.Attribute("CompetencePoints", CompetencePartStatistic.CompetencePoints);
                Component.XML.Element.Attribute("CompetencePointsByWeight", CompetencePartStatistic.CompetencePointsByWeight);
                Component.XML.Element.Attribute("ID", CompetencePartStatistic.ID);
                Component.XML.Element.Attribute("Name", CompetencePartStatistic.Name);
                Component.XML.Element.Attribute("ResetCount", CompetencePartStatistic.ResetCount);
                Component.XML.Element.Attribute("Salary", CompetencePartStatistic.SalaryValue);

                Component.XML.Element.Attribute("DisplayValue", CompetencePartStatistic.DisplayValue);
                Component.XML.Element.Attribute("CaseStudyPointsPercent", CompetencePartStatistic.CaseStudyPointsPercent);
                Component.XML.Element.Attribute("CompetencePointsPercent", CompetencePartStatistic.CompetencePointsPercent);

                // tutaj stopnie trudnosci rozbite
                AppendStatisticAdvancedLevelList(Component.BLELearning.Statistic.AdvancedLevel.Restore(Student, CompetencePartStatistic.CompetenceID, CompetencePartStatistic.ID));

                Component.XML.Element.End();
            }
            #endregion

            #region Listy ocen i poziomow zaawansowania
            public void AppendToXML(List<BL.BO.AdvancedLevel> ListAdvancedLevel)
            {
                Component.XML.Element.Start("AdvancedLevelList");
                foreach (BL.BO.AdvancedLevel _loopAdvancedLevel in ListAdvancedLevel)
                {
                    Component.XML.Element.Start("AdvancedLevel");
                    Component.XML.Element.Attribute("ID", _loopAdvancedLevel.ID);
                    Component.XML.Element.Attribute("Name", _loopAdvancedLevel.Name);
                    Component.XML.Element.Attribute("Weight", _loopAdvancedLevel.Weight);
                    Component.XML.Element.End();
                }
                Component.XML.Element.End();
            }

            public void AppendToXML(List<BL.BO.EvaluationSheet> ListEvaluationSheet)
            {
                Component.XML.Element.Start("EvaluationSheetList");
                foreach (BL.BO.EvaluationSheet _loopEvaluationSheet in ListEvaluationSheet)
                {
                    Component.XML.Element.Start("EvaluationSheet");
                    Component.XML.Element.Attribute("ID", _loopEvaluationSheet.ID);
                    Component.XML.Element.Attribute("Name", _loopEvaluationSheet.Name);
                    Component.XML.Element.Attribute("Abbreviation", _loopEvaluationSheet.Abbreviation);
                    Component.XML.Element.Attribute("Weight", _loopEvaluationSheet.Weight);
                    Component.XML.Element.End();
                }
                Component.XML.Element.End();
            }
            #endregion

            #region Prywatne helpery
            private void AppendStatisticAdvancedLevelList(List<BL.BO.View.StatisticAdvancedLevel> ListStatisticAdvancedLevel)
            {
                Component.XML.Element.Start("AdvancedLevelList");
                int _sum = ListStatisticAdvancedLevel.Sum(x => (x.Count ?? 0));
                foreach (BL.BO.View.StatisticAdvancedLevel _loopAdvancedLevelStatistic in ListStatisticAdvancedLevel)
                {
                    Component.XML.Element.Start("AdvancedLevel");
                    Component.XML.Element.Attribute("Count", _loopAdvancedLevelStatistic.Count);
                    Component.XML.Element.Attribute("Sum", _sum);
                    Component.XML.Element.Attribute("CountPercent", BL.BasicUtility.PointPercent(_loopAdvancedLevelStatistic.Count, _sum));
                    Component.XML.Element.Attribute("ID", _loopAdvancedLevelStatistic.ID);
                    Component.XML.Element.Attribute("Name", _loopAdvancedLevelStatistic.Name);
                    Component.XML.Element.End();
                }
                Component.XML.Element.End();
            }

            private Dictionary<long?, string> _classNames = new Dictionary<long?, string>();
            private string GetClassName(long? ClassID)
            {
                if (!_classNames.ContainsKey(ClassID))
                {
                    _classNames.Add(ClassID, Component.BLELearning.Class.RestoreById(ClassID).Name);
                }
                return _classNames[ClassID];
            }

            private Dictionary<long?, string> _evaluationNames = new Dictionary<long?, string>();
            private string GetEvaluationName(long? EvaluationSheetID)
            {
                if (EvaluationSheetID.HasValue)
                {
                    if (!_evaluationNames.ContainsKey(EvaluationSheetID))
                    {
                        _evaluationNames.Add(EvaluationSheetID, Component.BLELearning.EvaluationSheet.Cache.RestoreName(EvaluationSheetID));
                    }
                    return _evaluationNames[EvaluationSheetID];
                }
                return string.Empty;
            }
            #endregion
        }
    }
}